const mongoose = require("mongoose");

const staffRoleSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: [true, "Role name is required"],
      unique: true,
      trim: true, // e.g., "Instructor", "Manager", "Receptionist"
    },
    description: String,
  },
  { timestamps: true }
);

const StaffRole = mongoose.model("StaffRole", staffRoleSchema);
module.exports = StaffRole;
